<?php
// ==========================================================
// 1. CONFIGURAÇÃO DE CONEXÃO
// ==========================================================
$host = "localhost";
$user = "root";
$pass = "";
$db   = "sismag";
$port = 3307; 

$conn = new mysqli($host, $user, $pass, $db, $port);

if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}

// 2. OBTÉM PARÂMETROS
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$tipo = filter_input(INPUT_GET, 'tipo', FILTER_SANITIZE_STRING);

if (!$id || !in_array($tipo, ['disciplina', 'atribuicao'])) {
    header("Location: verificar_disciplinas.php");
    exit();
}

$conn->begin_transaction();

if ($tipo == 'disciplina') {
    // ==========================================================
    // AÇÃO: ELIMINAR DISCIPLINA (ALTO RISCO)
    // ==========================================================

    // 1. VERIFICAÇÃO DE SEGURANÇA: CHECA SE HÁ NOTAS ASSOCIADAS
    // Mude 'notas' e 'disciplina_id' se sua tabela de notas tiver nomes diferentes.
    $stmt_check = $conn->prepare("SELECT 1 FROM notas WHERE disciplina_id = ? LIMIT 1");
    $stmt_check->bind_param("i", $id);
    $stmt_check->execute();
    $result_check = $stmt_check->get_result();

    if ($result_check->num_rows > 0) {
        $conn->rollback();
        // Redireciona de volta com status de bloqueio
        header("Location: verificar_disciplinas.php?status=blocked&id=" . $id);
        exit();
    }
    $stmt_check->close();

    try {
        // 2. ELIMINA ATRIBUIÇÕES RELACIONADAS (Risco baixo, deve ser feito antes)
        $stmt_atribuicao = $conn->prepare("DELETE FROM atribuicoes WHERE disciplina_id = ?");
        $stmt_atribuicao->bind_param("i", $id);
        $stmt_atribuicao->execute();
        $stmt_atribuicao->close();

        // 3. ELIMINA A DISCIPLINA
        $stmt_disciplina = $conn->prepare("DELETE FROM disciplinas WHERE id = ?");
        $stmt_disciplina->bind_param("i", $id);
        $stmt_disciplina->execute();
        $stmt_disciplina->close();
        
        $conn->commit();
        header("Location: verificar_disciplinas.php?status=success&id=" . $id);
        exit();

    } catch (Exception $e) {
        $conn->rollback();
        // Se houver um erro de transação (ex: chave estrangeira não tratada)
        header("Location: verificar_disciplinas.php?status=error&id=" . $id);
        exit();
    }

} elseif ($tipo == 'atribuicao') {
    // ==========================================================
    // AÇÃO: ELIMINAR ATRIBUIÇÃO (RISCO MÉDIO/BAIXO)
    // ==========================================================
    try {
        $stmt_atribuicao = $conn->prepare("DELETE FROM atribuicoes WHERE id = ?");
        $stmt_atribuicao->bind_param("i", $id);
        $stmt_atribuicao->execute();
        $stmt_atribuicao->close();

        $conn->commit();
        header("Location: verificar_disciplinas.php?status=success&id=" . $id);
        exit();

    } catch (Exception $e) {
        $conn->rollback();
        header("Location: verificar_disciplinas.php?status=error&id=" . $id);
        exit();
    }
}

$conn->close();
?>